using System;

public
class main
{
  public static void Main()
  {
    Rectangle prostokat = new Rectangle(100, 200, 50, 80);
    Triangle trojkat = new Triangle(
      new Point(10, 20), 
      new Point(15, 18), 
      new Point(42, 24)
    );
    Point punkt = new Point(150, 300);
    Shape[] tab = new Shape[3];
    tab[0] = prostokat;
    tab[1] = trojkat;
    tab[2] = punkt;
    for(int i = 0; i < tab.Length; i++){
      try{
        ((IShow)tab[i]).Show();
      }
      catch(InvalidCastException){
      }
    }
  }
}

interface IShow
{
  void Show();
}

public
abstract class Shape
{
  public int color;
  public virtual void Show()
  {
    Console.WriteLine("Metoda Show klasy bazowej");
  }
}

public
class Rectangle:Shape, IShow
{
  public int x;
  public int y;
  public int width;
  public int height;
  public Rectangle(int x, int y, int width, int height)
  {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
  }
  public override void Show()
  {
    Console.WriteLine("Parametry prostokta:");
    Console.WriteLine("wsprzdna x = {0}", x);
    Console.WriteLine("wsprzdna y = {0}", y);
    Console.WriteLine("dugo = {0}", width);
    Console.WriteLine("szeroko = {0}\n", height);
  }
}

public
class Triangle:Shape, IShow
{
  public Point a;
  public Point b;
  public Point c;
  public Triangle(Point a, Point b, Point c)
  {
    this.a = a;
    this.b = b;
    this.c = c;
  }
  public override void Show()
  {
    Console.WriteLine("Parametry trjkta:");
    Console.WriteLine("punkt a = ({0}, {1})", a.x, a.y);
    Console.WriteLine("punkt b = ({0}, {1})", b.x, b.y);
    Console.WriteLine("punkt c = ({0}, {1})\n", c.x, c.y);
  }
}

public
class Point:Shape
{
  public int x;
  public int y;
  public Point(int x, int y)
  {
    this.x = x;
    this.y = y;
  }
}
